// Playground - noun: a place where people can play

import UIKit
protocol Message {
    var messageString: String {get set}
    init(messageString: String)
    func prepareMessage()
}

protocol Sender {
    var message: Message? {get set}
    func sendMessage()
    func verifyMessage()
}

class PlainTextMessage: Message {
    var messageString: String
    required init(messageString: String) {
        self.messageString = messageString
    }
    func prepareMessage() {
        // Tutaj nie ma niczego do zrobienia.
    }
}

class AESEncryptedMessage: Message {
    var messageString: String
    required init(messageString: String) {
        self.messageString = messageString
    }
    func prepareMessage() {
        self.messageString = "AES: " + self.messageString
    }
}


class DESEncryptedMessage: Message {
    var messageString: String
    required init(messageString: String) {
        self.messageString = messageString
    }
    func prepareMessage() {
        self.messageString = "DES: " + self.messageString
    }
}


class EmailSender: Sender {
    var message: Message?
    func sendMessage() {
        print("Wysłanie wiadomości przez e-mail:")
        print("     \(message!.messageString)")
    }
    func verifyMessage() {
        print("Weryfikacja wiadomości e-mail")
    }
}

class SMSSender: Sender {
    var message: Message?
    func sendMessage() {
        print("Wysłanie wiadomości przez SMS:")
        print("     \(message!.messageString)")
    }
    func verifyMessage() {
        print("Weryfikacja wiadomości SMS")
    }
}

struct MessageingBridge {
    static func sendMessage(message: Message, sender: Sender) {
        var sender = sender
        message.prepareMessage()
        sender.message = message
        sender.verifyMessage()
        sender.sendMessage()
    }
    
}

var myMessage = PlainTextMessage(messageString: "Zwykła wiadomość tekstowa")
var myEncMessage = AESEncryptedMessage(messageString: "Wiadomość zaszyfrowana")

MessageingBridge.sendMessage(message: myMessage, sender: SMSSender())

MessageingBridge.sendMessage(message: myMessage, sender: EmailSender())

MessageingBridge.sendMessage(message: myEncMessage, sender: EmailSender())

